﻿<%@ Page Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="PatientImaging.aspx.cs" Inherits="PatientImaging" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<%@ Import  Namespace="System.Web.Security.AntiXss" %>

<asp:Content ID="ContentMain" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">

    <asp:ScriptManager ID="ScriptManager1" runat="server" OnAsyncPostBackError="ScriptManager1_AsyncPostBackError" AllowCustomErrorsRedirect="false">
    </asp:ScriptManager>

    <telerik:RadAjaxManager ID="RadAjaxManager1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="RadAjaxManager1">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="LatePanel" 
                        LoadingPanelID="RadAjaxLoadingPanel1"/>
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="LatePanel">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="LatePanel" 
                        LoadingPanelID="RadAjaxLoadingPanel1"/>
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManager>
    
    <telerik:RadAjaxLoadingPanel ID="RadAjaxLoadingPanel1" runat="server" Skin="Vista" MinDisplayTime="1000">
    </telerik:RadAjaxLoadingPanel>
    
    <telerik:RadCodeBlock ID="RadCodeBlock1" runat="server">

        <script type="text/javascript">
            var isInitialLoad = true;
            
            function pageLoad(sender, args)
            {
                if (isInitialLoad)
                {
                    isInitialLoad = false;
                    var manager = $find('<%= RadAjaxManager1.ClientID %>');
                    manager.ajaxRequest("RebindLatePanel");
                }
            }

            $(document).ready(function () {

                var jointSelection = $('#<%=RadComboBoxJointSpace.ClientID %>').val();
                if (jointSelection == 'Yes') {
                    $('#<%=RadTextBoxJoint.ClientID%>').prop('disabled', false);
                }

                var hasRecord = $('#<%=HiddenFieldHasHistory.ClientID%>').val();
                if (hasRecord) {
                    if (hasRecord > 0) {
                        $('#<%=DeleteButton.ClientID%>').prop('disabled', false);
                    } else {
                        $('#<%=DeleteButton.ClientID%>').prop('disabled', true);
                    }
                }

                $('#<%=RadComboBoxFragmentVerified.ClientID %>').change(function () {

                    dateVar = new Date();  
                    var datepicker = $find("<%= RadDatePickerDateImagingReviewedByStaff.ClientID %>");  
                    datepicker.set_selectedDate(dateVar); 
                });

            }); // $(document).ready(function ()

            function RadComboBoxJointSpaceOnClientLoad(sender) {

                var item = sender.get_selectedItem();
                if (item) {
                    var text = item.get_text();

                    if (text.indexOf('Yes') !== -1) {
                    $('#<%=RadTextBoxJoint.ClientID%>').prop('disabled', false);
                    } else {
                        $('#<%=RadTextBoxJoint.ClientID%>').prop('disabled', true);
                        $('#<%=RadTextBoxJoint.ClientID%>').val('');
                    }
                } 
            }

            function RadComboBoxJointSpaceOnClientSelectedIndexChanged(sender, args) {

                var text = args.get_item().get_text();

                if (text.indexOf('Yes') !== -1) {
                    $('#<%=RadTextBoxJoint.ClientID%>').prop('disabled', false);
                } else {
                    $('#<%=RadTextBoxJoint.ClientID%>').prop('disabled', true);
                    $('#<%=RadTextBoxJoint.ClientID%>').val('');
                }
            }

            function OnClientLoad(editor, args) {
                var buttonsHolder = $get(editor.get_id() + "Top");
                var buttons = buttonsHolder.getElementsByTagName("A");
                for (var i = 0; i < buttons.length; i++) {
                    var a = buttons[i];
                    a.tabIndex = -1;
                    a.tabStop = false;
                }
            }

            // *****************************************************************************************
            // AJAX Error Handling
            var divElem = 'AlertDiv';
            var messageElem = 'AlertMessage';
            var bodyTag = 'Errors';
            var alertButtons = 'AlertButtons';
            Sys.WebForms.PageRequestManager.getInstance().add_endRequest(EndRequestHandler);

            function ToggleAlertDiv(visString) {
                if (visString == 'hidden') {
                    $get(bodyTag).style.backgroundColor = 'white';
                }
                else {
                    $get(bodyTag).style.backgroundColor = 'gray';

                    $get(alertButtons).style.display = 'block';
                }
                var adiv = $get(divElem);
                adiv.style.visibility = visString;
            }

            function ClearErrorState() {
                $get(messageElem).innerHTML = '';
                ToggleAlertDiv('hidden');
            }

            function EndRequestHandler(sender, args) {
                if (args.get_error() != undefined) {
                    args.set_errorHandled(true);
                    ToggleAlertDiv('visible');

                    var message = args.get_error().message;
                    var components = message.split(": ");
                    if (components.length == 2) {
                        message = components[1];
                    }
                    $get(messageElem).innerHTML = message;
                }
            }

        </script>
    </telerik:RadCodeBlock>

    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "BreadCrumbLabel" runat="server" Text="Patients > Patient Lookup > Imaging > " />
    </div> 

    <!-- ********************************************************************************************** -->
    <!-- Patient Information -->
    <!-- ******************* -->
    <div>
        <fieldset runat="server">
            <h3 class="underline">Patient Information</h3>
            <asp:Label 
                SkinID="DataLabel" 
                ID="LabelforLabelPatientName" 
                runat="server" 
                AssociatedControlID="LabelPatientName" 
                ToolTip="Patient Name" >
                Patient Name:&nbsp;&nbsp;
            </asp:Label>
            <asp:Label 
                SkinID="DataLabel" 
                ID="LabelPatientName" 
                runat="server" 
                ToolTip="Patient Name" >
            </asp:Label>
            <br />

            <asp:Label 
                SkinID="DataLabel" 
                ID="LabelforLabelPatientSnum" 
                runat="server" 
                AssociatedControlID="LabelPatientSnum" 
                ToolTip="Patient SSN" >
                SSN:&nbsp;&nbsp;
            </asp:Label>
            <asp:Label 
                SkinID="DataLabel" 
                ID="LabelPatientSnum" 
                runat="server" 
                ToolTip="Patient SSN" >
            </asp:Label>
            <br />

            <asp:Label 
                SkinID="DataLabel" 
                ID="LabelforImagingReviewed" 
                runat="server" 
                AssociatedControlID="LabelImagingReviewedHeader" 
                ToolTip="Date Imaging Reviewed by Staff" >
                Date Imaging Reviewed by Staff (mm/dd/yyyy):&nbsp;&nbsp;
            </asp:Label>
            <asp:Label 
                SkinID="DataLabel" 
                ID="LabelImagingReviewedHeader" 
                runat="server" 
                ToolTip="Date Imaging Reviewed by Staff" >
            </asp:Label>
            <br /> 

            <asp:Label 
                SkinID="DataLabel" 
                ID="LabelForFragmentVerified" 
                runat="server" 
                AssociatedControlID="LabelFragmentVerifiedHeader" 
                ToolTip="Fragment Verified" >
                Fragment Verified:&nbsp;&nbsp;
            </asp:Label>
            <asp:Label 
                SkinID="DataLabel" 
                ID="LabelFragmentVerifiedHeader" 
                runat="server" 
                ToolTip="Was a Fragment Verified?" >
            </asp:Label>
        <br /> 
        </fieldset>
    </div>
   <br />

    <!-- ********************************************************************************************** -->
    <!-- Images Fragments Summary -->
    <!-- ************************ -->
    <div>
        <fieldset runat="server">
            <h3 class="underline">Images Fragments Summary</h3>
            <table align= "left" class="style1" cellpadding = "5" cellspacing = "5" border="0">

                <tr style = "height:20px;">
                    <td class="style3">
                        <asp:Label 
                            ID="LabelInCprs" 
                            runat="server" 
                            AssociatedControlID="RadComboBoxInCprs" 
                            SkinID="DataLabel" 
                            Text="Are Images and/or Imaging Reports Available Within CPRS?">
                        </asp:Label>   
                        <telerik:radcombobox 
                            id="RadComboBoxInCprs" 
                            runat="server"
                            EmptyMessage="(Select a Value)"> 
                        </telerik:radcombobox>     
                    </td>
                </tr>

                <tr style = "height:20px;">
                    <td class="style3">
                        <asp:Label 
                            ID="LabelFragmentVerified" 
                            runat="server" 
                            AssociatedControlID="RadComboBoxFragmentVerified" 
                            SkinID="DataLabel" 
                            Text="Fragment Verified?">
                        </asp:Label> 
                        <telerik:radcombobox 
                            id="RadComboBoxFragmentVerified" 
                            runat="server"
                            EmptyMessage="(Select a Value)"> 
                        </telerik:radcombobox>
                    </td>
                </tr>

                <tr style = "height:20px;">
                    <td class="style3">
                        <asp:Label 
                            SkinID="DataLabel" 
                            runat="server" 
                            ID="LabelBoneFracture" 
                            Text="Is There Documentation of a Bone Fracture?"
                            AssociatedControlID="RadComboBoxBoneFracture">
                        </asp:Label>
                        <telerik:radcombobox 
                            id="RadComboBoxBoneFracture" 
                            runat="server"
                            EmptyMessage="(Select a Value)"> 
                        </telerik:radcombobox>
                    </td>
                </tr>

                <tr style = "height:20px;">
                    <td class="style3">
                        <asp:Label 
                            SkinID="DataLabel" 
                            runat="server" 
                            ID="LabelFragmentSize" 
                            Text="Are the Majority of Fragments Predominately:"
                            AssociatedControlID="RadComboBoxFragmentSize">
                        </asp:Label> 
                        <telerik:radcombobox 
                            id="RadComboBoxFragmentSize" 
                            runat="server"
                            EmptyMessage="(Select a Value)"> 
                        </telerik:radcombobox>     
                    </td>
                </tr>

                <tr style = "height:20px;">
                    <td class="style3">
                        <asp:Label 
                            SkinID="DataLabel" 
                            runat="server" 
                            ID="LabelJointSpace" 
                            Text="Are any of the fragments located within a joint space?"
                            AssociatedControlID="RadComboBoxJointSpace">
                        </asp:Label>
                        <telerik:radcombobox 
                            id="RadComboBoxJointSpace" 
                            runat="server"
                            EmptyMessage="(Select a Value)" 
                            OnClientLoad="RadComboBoxJointSpaceOnClientLoad"
                            OnClientSelectedIndexChanged="RadComboBoxJointSpaceOnClientSelectedIndexChanged"> 
                        </telerik:radcombobox>
                        <asp:Label 
                            SkinID="DataLabel" 
                            runat="server" 
                            ID="LabelJoint" 
                            Text="Joint:"
                            AssociatedControlID="RadTextBoxJoint">
                        </asp:Label>
                        <telerik:RadTextBox
                            ID="RadTextBoxJoint" 
                            runat="server" 
                            Width="428px" >
                        </telerik:RadTextBox>
                    </td>
                </tr>

                <tr style = "height:20px;">
                    <td class="style3">
                        <asp:Label 
                            SkinID="DataLabel" 
                            runat="server" 
                            ID="LabelOtherObservations" 
                            Text="Other Fragment Related Observations:" 
                            AssociatedControlID="RadTextBoxOtherObservations">
                        </asp:Label>
                        <telerik:RadTextBox  
                            RenderMode="Lightweight" 
                            Height="119px" 
                            Width="1007px" 
                            EmptyMessage="Enter other observations"
                            ID="RadTextBoxOtherObservations" 
                            runat="server" 
                            TextMode="MultiLine">
                        </telerik:RadTextBox>
                    </td>
                </tr>

                <tr style = "height:20px;">
                    <td class="style3">
                        <asp:Label 
                            ID="LabelDateImagingReviewedByStaff" 
                            runat="server" 
                            AssociatedControlID="RadDatePickerDateImagingReviewedByStaff" 
                            SkinID="DataLabel" 
                            Text="Date Imaging Reviewed by Staff (mm/dd/yyyy):">
                        </asp:Label> 
                        <telerik:RadDatePicker ID="RadDatePickerDateImagingReviewedByStaff" runat="server" >
                            <Calendar ID="CalendarDateImagingReviewedByStaff" runat="server"></Calendar>
                        </telerik:RadDatePicker>
                    </td>
                </tr>

            </table>
        </fieldset>
    </div>
   <br />

    <!-- ********************************************************************************************** -->
    <!-- Buttons -->
    <!-- ******* -->
    <table width="100%">
        <tr>
            <td align="left">
                <asp:Button 
                    runat = "server" 
                    ID = "BackButton" 
                    Text = "Back" 
                    Width = "130px" 
                    OnClick="BackButton_Click"
                    UseSubmitBehavior = "false" 
                    CausesValidation="false"
                    ToolTip="Return to previous page."/>
                <asp:Button 
                    runat = "server" 
                    ID = "SaveButton" 
                    Text = "Save" 
                    Width = "130px" 
                    OnClick = "SaveButton_Click" 
                    UseSubmitBehavior = "true" 
                    ToolTip="Save entries." />
                <asp:Button 
                    runat = "server" 
                    ID = "DeleteButton" 
                    Text = "Delete" 
                    Width = "130px" 
                    OnClick = "DeleteButton_Click"
                    OnClientClick="return confirm('Are you certain you want to delete this record?');"
                    Disabled="disabled"
                    UseSubmitBehavior = "true" 
                    CausesValidation="false"
                    ToolTip="Delete record."/>
            </td>
        </tr>
    </table> 
    <br />
    <br />

    <div id="Errors">
        <div id="AlertDiv">
            <div id="AlertMessage">
            </div>
            <br />
            <div id="AlertButtons" style="display:none;">
                <asp:Button 
                    runat = "server" 
                    ID = "OKButton" 
                    Text = "OK" 
                    Width = "130px" 
                    OnClientClick="ClearErrorState();"
                    UseSubmitBehavior = "true" 
                    CausesValidation="false"
                    ToolTip="Close error message."/>
            </div>
        </div>
    </div>

    <div>
        <fieldset runat="server" ID="LatePanel">
            <h3 class="underline">Images</h3>

            <telerik:RadGrid 
                ID="RadGridImages" 
                GridLines="None" 
                AutoGenerateColumns="false" 
                PageSize="10"
                AllowPaging="true" 
                AllowSorting="true" 
                runat="server" 
                AllowAutomaticUpdates="true" 
                ShowStatusBar="true">

                <MasterTableView 
                    ShowFooter="false" 
                    DataKeyNames="PATIENT_IMAGE_ID" 
                    EditMode="InPlace" >

                    <Columns>
                        <telerik:GridNumericColumn
                            Visible="false"
                            DataType="System.Int32"  
                            DataField="PATIENT_ID" 
                            HeaderText="PATIENT_ID" 
                            SortExpression="PATIENT_ID" 
                            UniqueName="PATIENT_ID" >
                        </telerik:GridNumericColumn>

                        <telerik:GridNumericColumn
                            Visible="false"
                            DataType="System.Int32"  
                            DataField="PATIENT_IMAGE_ID" 
                            HeaderText="PATIENT_IMAGE_ID" 
                            SortExpression="PATIENT_IMAGE_ID" 
                            UniqueName="PATIENT_IMAGE_ID" >
                        </telerik:GridNumericColumn>

                        <telerik:GridDateTimeColumn 
                            DataField="DATE_IMAGED" 
                            DataType="System.DateTime" 
                            DataFormatString="{0:MM/dd/yyyy}"  
                            HeaderText="Date Imaged" 
                            SortExpression="DateImaged" 
                            UniqueName="DateImaged"
                            ReadOnly="true">  
                        </telerik:GridDateTimeColumn>  

                        <telerik:GridTemplateColumn 
                            DataField="SYSTEM_IDENTIFIED_FRAGMENT"
                            DataType="System.String" 
                            HeaderText="System Identified" 
                            SortExpression="SystemIdentified" 
                            UniqueName="SystemIdentified"
                            ReadOnly="true">  
                            <ItemTemplate>
                                <%#AntiXssEncoder.HtmlEncode(Convert.ToString(DataBinder.Eval(Container.DataItem, "SYSTEM_IDENTIFIED_FRAGMENT")), false)%>
                            </ItemTemplate>
                        </telerik:GridTemplateColumn> 

                        <telerik:GridTemplateColumn 
                            DataField="FRAGMENT_VERIFIED"
                            DataType="System.String" 
                            HeaderText="Fragment Verified" 
                            SortExpression="FragmentVerified" 
                            UniqueName="FragmentVerified"
                            ReadOnly="true">  
                            <ItemTemplate>
                                <%#AntiXssEncoder.HtmlEncode(Convert.ToString(DataBinder.Eval(Container.DataItem, "FRAGMENT_VERIFIED")), false)%>
                            </ItemTemplate>
                        </telerik:GridTemplateColumn> 

                        <telerik:GridTemplateColumn 
                            DataField="REVIEWED"
                            DataType="System.String" 
                            HeaderText="Reviewed" 
                            SortExpression="Reviewed" 
                            UniqueName="Reviewed"
                            ReadOnly="true">  
                            <ItemTemplate>
                                <%#AntiXssEncoder.HtmlEncode(Convert.ToString(DataBinder.Eval(Container.DataItem, "REVIEWED")), false)%>
                            </ItemTemplate>
                        </telerik:GridTemplateColumn> 

                        <telerik:GridTemplateColumn 
                            DataType="System.String" 
                            HeaderText="Body Part(s) Imaged" 
                            SortExpression="ImageBodyParts" 
                            UniqueName="ImageBodyParts"
                            ReadOnly="true">  
                            <ItemTemplate>
                                <%#AntiXssEncoder.HtmlEncode(GetBodyPartsImaged(DataBinder.Eval(Container.DataItem, "PATIENT_IMAGE_ID")), false)%>
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>

                        <telerik:GridTemplateColumn 
                            HeaderText="Image Fragment Count">
                            <ItemTemplate>
                                <%#AntiXssEncoder.HtmlEncode(Convert.ToString(DataBinder.Eval(Container.DataItem, "IMAGE_FRAGMENT_COUNT_DESCRIPTION_TEXT")), false)%>
                            </ItemTemplate>
                            <EditItemTemplate>        
                                <telerik:RadComboBox 
                                    runat="server" 
                                    ID="RadComboBoxFragmentCount" 
                                    DataTextField="DESCRIPTION_TEXT"
                                    DataValueField ="ID" 
                                    DataSourceID ="SqlDataSourceImageFragmentCount" 
                                    SelectedValue='<%#Bind("STD_IMAGE_FRAGMENT_COUNT_ID") %>'>
                                    <DefaultItem Text="" Value=""></DefaultItem>
                                </telerik:RadComboBox>
                            </EditItemTemplate>
                        </telerik:GridTemplateColumn>

                        <telerik:GridHyperLinkColumn 
                            DataTextFormatString="Viewer"
                            DataNavigateUrlFields="IMAGE_URL" 
                            UniqueName="ImageUrl" 
                            DataNavigateUrlFormatString=""
                            HeaderText="Image Url" 
                            DataTextField="IMAGE_URL"
                            Target="_blank">
                        </telerik:GridHyperLinkColumn>

                        <telerik:GridTemplateColumn 
                            AllowFiltering="false" 
                            UniqueName="Details"
                            HeaderText="Details">
                            <ItemTemplate>
                                <a href="PatientImageDetails.aspx?patientId=<%#AntiXssEncoder.UrlEncode(Convert.ToString(Eval("PATIENT_ID")))%>&patientImageId=<%#AntiXssEncoder.UrlEncode(Convert.ToString(Eval("PATIENT_IMAGE_ID")))%>"> 
                                    View\Edit Details
                                </a>
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>

                    </Columns>

                </MasterTableView>

            </telerik:RadGrid>

            <!-- ************ -->
            <!-- Data Sources -->

            <asp:SqlDataSource 
                ID="SqlDataSourceImageFragmentCount" 
                runat="server" 
                ConnectionString="<%$ ConnectionStrings:RegistryConnectionString %>" 
                SelectCommand="[EFR].[usp_GetStandardFragmentCount]"      
                SelectCommandType="StoredProcedure">
            </asp:SqlDataSource>

        </fieldset>
    </div>
   <br />

    <!-- ********************************************************************************************** -->
    <!-- Other -->
    <asp:HiddenField runat="server" ID="PageSaveCount" Value="0"/>
    <asp:HiddenField runat="server" ID="HiddenFieldHasHistory" Value="0"/>

</asp:Content>
